#ifndef __CTriStateImage__
#define __CTriStateImage__

#include "CControl.hpp"
using Exponent::GUI::Controls::CControl;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CTriStateImage CTriStateImage.hpp
			 * @brief Shows three images and allows you to choose which
			 *
			 * @date 03/09/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CTriStateImage.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CTriStateImage : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 */
				CTriStateImage(IControlRoot *root, const long uniqueId, const CRect &area);

				/**
				 * Destruction
				 */
				virtual ~CTriStateImage();

//	===========================================================================

				/**
				 * Draw the controls
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

				/**
				 * Set the handle images
				 * @param image1 Image state 1
				 * @param image2 Image state 2
				 * @param image3 Image state 3
				 */
				void setImages(IImage *image1, IImage *image2, IImage *image3);

				/**
				 * Set the state
				 * @param state The state to display (0, 1 or 2)
				 */
				void setState(const long state);

//	===========================================================================


			protected:

//	===========================================================================

				IImage *m_images[3];		/**< The three images */
				long m_currentState;		/**< The current state */
			};
		}
	}
}
#endif		// End of CTriStateImage.hpp